/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.ModConfig;
import dev.quarris.ppfluids.client.FluidBlobRenderer;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidPipeItem
extends PipeItem {
    public static final ResourceLocation FLUID_TYPE = new ResourceLocation("prettypipes", "pipe_fluid");
    private long ticksExisted;

    public FluidPipeItem(ItemStack stack, float speed) {
        super(FLUID_TYPE, stack, speed);
    }

    public FluidPipeItem(CompoundTag nbt) {
        this(FLUID_TYPE, nbt);
    }

    public FluidPipeItem(ResourceLocation type, CompoundTag nbt) {
        super(type, nbt);
        this.ticksExisted = nbt.m_128454_("TicksExisted");
    }

    public FluidStack getFluidContent() {
        IFluidHandlerItem tank = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)this.stack).orElse(null);
        if (tank != null) {
            return tank.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public void updateInPipe(PipeBlockEntity currPipe) {
        super.updateInPipe(currPipe);
        ++this.ticksExisted;
    }

    public void drop(Level level, ItemStack stack) {
        if (((Boolean)ModConfig.dropFluidContainers.get()).booleanValue()) {
            super.drop(level, stack);
        }
    }

    public long getTicksExisted() {
        return this.ticksExisted;
    }

    protected void onPathObstructed(PipeBlockEntity currPipe, boolean tryReturn) {
        if (currPipe.m_58904_().m_5776_()) {
            return;
        }
        PipeNetwork network = PipeNetwork.get((Level)currPipe.m_58904_());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.m_58899_(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            FluidStack remain = PipeNetworkUtil.routeFluid(currPipe.m_58904_(), currPipe.m_58899_(), this.destInventory, FluidItem.getFluidCopyFromItem(this.stack), (stack, speed) -> this, false);
            if (!remain.isEmpty()) {
                this.drop(currPipe.m_58904_(), FluidItem.createItemFromFluid(remain, false));
            }
        } else {
            this.drop(currPipe.m_58904_(), this.stack);
        }
    }

    protected ItemStack store(PipeBlockEntity currPipe) {
        if (currPipe instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity currFluidPipe = (FluidPipeBlockEntity)currPipe;
            Direction dir = Utility.getDirectionFromOffset((BlockPos)this.getDestInventory(), (BlockPos)this.getDestPipe());
            IPipeConnectable connectable = currFluidPipe.getPipeConnectable(dir);
            if (connectable != null) {
                return connectable.insertItem(currFluidPipe.m_58899_(), dir, this.stack, false);
            }
            IFluidHandler handler = currFluidPipe.getFluidHandler(dir);
            if (handler == null) {
                return this.stack;
            }
            return FluidItem.insertFluid(handler, this.stack, false);
        }
        return super.store(currPipe);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128356_("TicksExisted", this.ticksExisted);
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeBlockEntity tile, PoseStack matrixStack, Random random, float partialTicks, int light, int overlay, MultiBufferSource buffer) {
        FluidBlobRenderer.render(this, matrixStack, random, partialTicks, light, overlay, buffer);
    }
}

